 ; Ŀ
 ;   Scream - replace an attribute in a number of blocks.                  
 ;   Copyright 1993, 1995, 2005, 2008 by Rocket Software Ltd.              
 ;   Dedicated to the nice people at the Screamin' Skulls Daycare.         
 ; 

 ; Ŀ
 ;   Blocked: subroutine to edit the terminal strip numbers.               
 ;   Order is the list of enames in order by position.                     
 ;   (Actually that part makes no sense in the current context...)         
 ; 
 (DEFUN BLOCKED (order attnam pstr / pos enam esav ent vis)
;  (if (or (/= (type pstr) 'STR) (= pstr ""))
;      (setq pstr ()))
 ; Ŀ
 ;   This section is commented out - strings are now acquired by Tget.     
 ; 
 ; Ŀ
 ;   Initget 128 allows arbitrary input for getpoint.                      
 ;   If the input is a point then nentsel at that point can get the        
 ;   attribute value.  A return = nil.                                     
 ; 
;  (initget 128)
;  (if pstr
;      (setq pa (getpoint (strcat "\nEnter Text <"
;                                  pstr "> or Select an Example: ")))
;      (setq pa (getpoint "\nEnter Text or Select an Example: ")))
 ; Ŀ
 ;   Figure out what we have, and what remains to be found.                
 ; 
;  (cond ((and (null pa) pstr)
;         (setq pstr pstr))
;        ((null pa)
;         (setq pstr ""))
;        ((= (type pa) 'str)
;         (setq pstr pa))
;        ((= (type pa) 'list)
;         (setq nn (nentselp pa))
;         (if nn (setq pstr (cdr (assoc 1 (entget (car nn))))))))
 ; Ŀ
 ;   Process the block list: insert the new value.                         
 ; 
  (setq pos 0)
  (while (setq enam (nth pos order))
         (setq esav enam)
         (setq pos (1+ pos))
         (setq ent (entget enam))
         (while (/= "SEQEND" (cdr (assoc 0 ent)))
                (if (or (= (cdr (assoc 2 ent)) attnam)  ; if att to change
                        (= attnam " "))                 ; or change all flag
                    (progn
 ; Ŀ
 ;   The next 7 lines are used to turn the attribute visibility on, set    
 ;   height to the correct value, and put the attribute on the layer Text. 
 ;   These are a good idea if one is using cadpipe drawings, superfluous   
 ;   otherwise.                                                            
 ; 
                        (if tagth
                            (setq ent (subst (cons 40 tagth)
                                      (assoc 40 ent) ent)))
                        (setq vis (cdr (assoc 70 ent)))   ; get att flags
                        (setq vis (logand 14 vis))        ; turn visibility on
                        (setq ent (subst (cons 70 vis) (assoc 70 ent) ent))
 ;                      (setq ent (subst (cons 8 "TEXT") (assoc 8 ent) ent))
 ; Ŀ
 ;   Vestigial cadpipe section end.                                        
 ; 
                        (entmod (subst (cons 1 pstr) (assoc 1 ent) ent))))
                (setq ent (entget (setq enam (entnext enam)))))
         (entupd esav)))
 ; Ŀ
 ;   Blocked end.                                                          
 ; 

 ; Ŀ
 ;   Subroutine Verti: returns a list of block names in order by position. 
 ; 
 (DEFUN VERTI (/ xposnam yposnam maxi mini ss numm ent entt xpos ypos xx yy pn
                 maxx minx maxy miny xdif ydif poslst posnam direct pos llast
                 order)
  (setq xposnam ())                      ; initialize (xpos & name list) list
  (setq yposnam ())                      ; initialize (ypos & name list) list
  (setq maxi (list 'max))                ; initialize max & min command lists
  (setq mini (list 'min))                ; (a lisp command is also a list)
 ; Ŀ
 ;   Get an ss and remove non-insert entities.                             
 ; 
  (write-line "Select blocks to edit: ")
  (setq ss (ssget))                      ; select some entities
  (setq numm 0)                          ; start at beginning of selection set
  (while (setq ent (ssname ss numm))     ; get the first entity name
         (setq entt (entget ent))        ; get the whole thing
         (if (= (cdr (assoc 0 entt)) "INSERT")    ; if it was a block
             (setq numm (1+ numm))       ; go to next entity
             (ssdel ent ss)))            ; otherwise remove it from the ss
 ; Ŀ
 ;   Now see if the entities are arranged horizontally or vertically.      
 ; 
  (setq numm 0)                             ; start at the ss beginning again
  (while (setq ent (ssname ss numm))
         (setq entt (entget ent))
         (setq xpos (cadr (assoc 10 entt)))
         (setq ypos (caddr (assoc 10 entt)))
         (setq xx (append xx (list xpos)))  ; add x insert to list
         (setq yy (append yy (list ypos)))  ; and y to y list
 ; Ŀ
 ;   Also make the position and name list.  Have to make one for the X     
 ;   values and one for the Ys and use the appropriate one later.          
 ; 
         (setq pn (cons xpos ent))
         (setq xposnam (append xposnam (list pn)))
         (setq pn (cons ypos ent))
         (setq yposnam (append yposnam (list pn)))
         (setq numm (1+ numm)))             ; next entity
 ; Ŀ
 ;   Now make the four command lists and evaluate them.  The result will   
 ;   be the max and min values for the X and Y lists.                      
 ; 
  (setq maxx (eval (append maxi xx)))
  (setq minx (eval (append mini xx)))
  (setq maxy (eval (append maxi yy)))
  (setq miny (eval (append mini yy)))
  (setq xdif (- maxx minx))
  (setq ydif (- maxy miny))
 ; Ŀ
 ;   Set vert to T if vertical, nil if horizontal.  If not sure, assume    
 ;   vertical... I think... Could set strip to Quit and thus do so.        
 ; 
  (cond ((> xdif ydif)                     ; if (Xmax - Xmin) > (Ymax - Ymin)
          (setq poslst xx)                 ; positions from X coord list
          (setq posnam xposnam)            ; position & ename list with X coord
          (setq direct mini))              ; edit from smallest to largest X
        ((< xdif ydif)
          (setq poslst yy)
          (setq posnam yposnam)
          (setq direct maxi))
        (T                                 ; if not sure then call it vertical
          (setq poslst yy)
          (setq posnam yposnam)
          (setq direct maxi)))
 ; Ŀ
 ;   Now make the list of enames in order by increasing X or decreasing Y  
 ;   coordinate depending on whether the array is horizontal or vertical.  
 ;                                                                         
 ;   Already Have Posnam: a list of (list position ename).                 
 ;   Using the original list of either x or y positions, get the first or  
 ;   last as appropriate, extract the ename from Posnam using              
 ;   (cdr (assoc (largest Y or smallest X) posnam))                        
 ;   and append the ename to the end of the enames in order list: Order.   
 ;   Then remove that position from the position list.                     
 ;                                                                         
 ; 
  (while (> (length poslst) 0)
 ; Ŀ
 ;   Get the largest Y or smallest X value in the position list.           
 ; 
         (setq maxx (eval (append direct poslst)))
 ; Ŀ
 ;   Having found Maxx, want to remove that value from poslst.             
 ;   Get the list from Maxx on, and the position of Maxx within the list.  
 ; 
         (setq pos (- (length poslst)
                      (length (setq llast (member maxx poslst)))))
 ; Ŀ
 ;   Get the list after maxx.                                              
 ; 
         (setq llast (cdr llast))
 ; Ŀ
 ;   And add the list members before maxx.                                 
 ;   One could use (cdr (member (reverse poslist))) but if there were two  
 ;   values the same in the list this would result in a longer rather      
 ;   than a shorter poslist.                                               
 ; 
         (setq pos (1- pos))     ; subtract one: nth is zero based
         (while (>= pos 0)
                (setq llast (append (list (nth pos poslst)) llast))
                (setq pos (1- pos)))
         (setq poslst llast)      ; poslst becomes llast
 ; Ŀ
 ;   Now get the matching ename from posnam and add it to the end of the   
 ;   order list.                                                           
 ; 
         (setq order (append order (list (cdr (assoc maxx posnam)))))
 ; Ŀ
 ;   If there are two entities with the same position then assoc will      
 ;   always return the first one.  Must delete the first one each time -   
 ;   subst (nil) for it.                                                   
 ; 
         (setq posnam (subst (list nil) (assoc maxx posnam) posnam)))
 order)
 ; Ŀ
 ;   Verti end.                                                            
 ; 

 ; Ŀ
 ;   Batter - replacement error handler.  Restores original values to      
 ;   attributes if something goes wrong.                                   
 ; 
 (DEFUN BATTER (shk / pos entt enam sublst vall)
  (setvar "snapmode" snapp)
  (if (and esav main)
      (progn
           (setq pos 0)
           (setq entt (entget (setq enam esav)))
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq sublst (nth pos main))
                  (setq vall (cadr sublst))
                  (setq pos (1+ pos))
                  (entmod (subst (cons 1 vall) (assoc 1 entt) entt)))
           (entupd esav)))
  (setq *error* esav)
  (if shk (write-line shk))
 (princ))
 ; Ŀ
 ;   Batter end.                                                           
 ; 

 ; Ŀ
 ;   Tget - get a string by keyboard entry or entity selection at the      
 ;   same prompt.                                                          
 ;   Takes no arguments, but uses the global variable pstr.                
 ;   Returns a string or nil.                                              
 ;   Calls nothing.                                                        
 ; 
 (DEFUN TGET (/ goon ppstr aa pa)
  (if (= (type pstr) 'STR)
      (prompt (strcat "\nEnter Text or Select an Example (<Return> = "
                       pstr "): "))
      (prompt "\nEnter Text or Select an Example: "))
 ; Ŀ
 ;   Use grread to get points so can also accept keyboard input.           
 ; 
  (setq ppstr "")
  (setq goon t)
  (while (and goon (setq aa (grread () 4 2)))
         (cond ((= (car aa) 3)                             ; a point
                (setq goon ())                             ; leave loop
                (setq pa (cadr aa)))                       ; save point
               ((equal aa (list 2 13))                     ; Keyboard <Return>
                (setq goon ()))                            ; leave looop
               ((equal (car aa) 25)                        ; Mouse <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 6 0))                      ; Digitizer <Return>
                (setq goon ()))                            ; leave looop
               ((equal aa (list 2 2))                      ; F9
                (setvar "snapmode" (abs (1- (getvar "snapmode")))))
               ((equal aa (list 2 15))                     ; F8
                (setvar "orthomode" (abs (1- (getvar "orthomode")))))
               ((equal (car aa) 2)                         ; a keypress
                (setq ppstr (strcat ppstr (setq aa (chr (cadr aa)))))
                (princ aa))))
  (if pa
      (progn
           (if (/= ppstr "") (prompt "\nPoint override."))
           (if (setq ppstr (nentselp pa))
               (if (= (type (caar (reverse ppstr))) 'ENAME)
                   (setq pstr (cdr (assoc 1 (entget (caar (reverse ppstr))))))
                   (setq pstr (cdr (assoc 1 (entget (car ppstr))))))
              (setq pstr ())))
      (if (/= ppstr "") (setq pstr ppstr)))
 pstr)
 ; Ŀ
 ;   Tget end.                                                             
 ; 

 ; Ŀ
 ;   Scream - the braincase.                                               
 ; 
 (DEFUN C:SCREAM (/ esav order main entt enam tagg vall sublst attnam pos)
  (command "undo" "m")                   ; set undo marker
  (setq errsav *error*)                    ; save the previous error handler
  (setq *error* batter)                  ; and install the new one
  (setq snapp (getvar "snapmode"))
  (setvar "snapmode" 0)
  (setq order (verti))     ; verti returns list of inserts ordered by position
  (setq main ())                         ; list of attribute values to restore
 ; Ŀ
 ;   Use the first insert in the ordered list Order to display the         
 ;   attribute tag names and ask which one to edit.                        
 ; 
  (while (and (car order)
              (null (assoc 66 (entget (car order)))))
         (setq order (cdr order)))
  (if (setq enam (car order))
      (setq entt (entget (setq esav enam))))
 ; Ŀ
 ;   Step through the insert, substituting the tag names for attribute     
 ;   values, save the original values so they can be restored.             
 ; 
  (if (and (= (cdr (assoc 0 entt)) "INSERT")
           (assoc 66 entt))
      (progn
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq tagg (cdr (assoc 2 entt)))
                  (setq vall (cdr (assoc 1 entt)))
                  (if (and tagg vall)
                      (progn
                           (setq sublst (list tagg vall))
                           (setq main (append main (list sublst)))
                           (entmod (subst (cons 1 tagg)
                                          (cons 1 vall) entt)))))
           (entupd esav)
 ; Ŀ
 ;   Prompt for an attribute to edit, get the tag.                         
 ; 
           (if (setq attnam (nentsel
                            "\nAttribute to edit or <Return> for all: "))
               (progn
                    (setq entt (entget (car attnam)))
                    (if (= (cdr (assoc 0 entt)) "ATTRIB")
                        (progn
                             (setq attnam (cdr (assoc 2 entt)))
                             (princ attnam))
                        (progn
                             (setq attnam nil)
                             (prompt "\nThat was not an attribute."))))
               (progn
                    (setq attnam " ")
                    (write-line "Changing all attributes.")))
 ; Ŀ
 ;   Restore the original values to the block from the list Main.          
 ; 
           (setq entt (entget (setq enam esav)))
           (setq pos 0)
           (while (/= (cdr (assoc 0 entt)) "SEQEND")
                  (setq enam (entnext enam))
                  (setq entt (entget enam))
                  (setq sublst (nth pos main))
                  (setq vall (cadr sublst))
                  (setq pos (1+ pos))
                  (entmod (subst (cons 1 vall) (assoc 1 entt) entt)))
           (entupd esav)))
 ; Ŀ
 ;   Now update the block insertions.                                      
 ; 
  (if attnam 
      (progn
 ; Ŀ
 ;   Call Tget to get a string.                                            
 ; 
           (if (setq stra (tget))
 ; Ŀ
 ;   Call blocked to edit the insertions.                                  
 ; 
               (blocked order attnam stra))))
 ; Ŀ
 ;   Clean up and end.                                                     
 ; 
  (setq *error* errsav)        ; restore the original error handler
  (setvar "snapmode" snapp)
 (princ))